/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;

public class VehicleControl
extends PhysicsVehicle
implements PhysicsControl {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected PhysicsSpace space = null;
    protected boolean added = false;

    public VehicleControl() {
    }

    public VehicleControl(CollisionShape shape) {
        super(shape);
    }

    public VehicleControl(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public boolean isApplyPhysicsLocal() {
        return this.motionState.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.motionState.setApplyPhysicsLocal(applyPhysicsLocal);
        for (VehicleWheel vehicleWheel : this.wheels) {
            vehicleWheel.setApplyLocal(applyPhysicsLocal);
        }
    }

    private Vector3f getSpatialTranslation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        VehicleControl control = new VehicleControl(this.collisionShape, this.mass);
        control.setAngularFactor(this.getAngularFactor());
        control.setAngularSleepingThreshold(this.getAngularSleepingThreshold());
        control.setAngularVelocity(this.getAngularVelocity());
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setDamping(this.getLinearDamping(), this.getAngularDamping());
        control.setFriction(this.getFriction());
        control.setGravity(this.getGravity());
        control.setKinematic(this.isKinematic());
        control.setLinearSleepingThreshold(this.getLinearSleepingThreshold());
        control.setLinearVelocity(this.getLinearVelocity());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setPhysicsRotation(this.getPhysicsRotationMatrix());
        control.setRestitution(this.getRestitution());
        control.setFrictionSlip(this.getFrictionSlip());
        control.setMaxSuspensionTravelCm(this.getMaxSuspensionTravelCm());
        control.setSuspensionStiffness(this.getSuspensionStiffness());
        control.setSuspensionCompression(this.tuning.suspensionCompression);
        control.setSuspensionDamping(this.tuning.suspensionDamping);
        control.setMaxSuspensionForce(this.getMaxSuspensionForce());
        for (VehicleWheel wheel : this.wheels) {
            Node node;
            Spatial wheelSpat;
            VehicleWheel newWheel = control.addWheel(wheel.getLocation(), wheel.getDirection(), wheel.getAxle(), wheel.getRestLength(), wheel.getRadius(), wheel.isFrontWheel());
            newWheel.setFrictionSlip(wheel.getFrictionSlip());
            newWheel.setMaxSuspensionTravelCm(wheel.getMaxSuspensionTravelCm());
            newWheel.setSuspensionStiffness(wheel.getSuspensionStiffness());
            newWheel.setWheelsDampingCompression(wheel.getWheelsDampingCompression());
            newWheel.setWheelsDampingRelaxation(wheel.getWheelsDampingRelaxation());
            newWheel.setMaxSuspensionForce(wheel.getMaxSuspensionForce());
            if (!(spatial instanceof Node) || (wheelSpat = (node = (Node)spatial).getChild(wheel.getWheelSpatial().getName())) == null) continue;
            newWheel.setWheelSpatial(wheelSpat);
        }
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        control.setSpatial(spatial);
        return control;
    }

    public void setSpatial(Spatial spatial) {
        if (this.getUserObject() == null || this.getUserObject() == this.spatial) {
            this.setUserObject(spatial);
        }
        this.spatial = spatial;
        if (spatial == null) {
            if (this.getUserObject() == spatial) {
                this.setUserObject(null);
            }
            this.spatial = null;
            this.collisionShape = null;
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float tpf) {
        if (this.enabled && this.spatial != null) {
            if (this.getMotionState().applyTransform(this.spatial)) {
                this.spatial.getWorldTransform();
                this.applyWheelTransforms();
            }
        } else if (this.enabled) {
            this.applyWheelTransforms();
        }
    }

    protected Spatial getDebugShape() {
        return super.getDebugShape();
    }

    public void render(RenderManager rm, ViewPort vp) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            Node debugNode = (Node)this.debugShape;
            this.debugShape.setLocalTranslation(this.spatial.getWorldTranslation());
            this.debugShape.setLocalRotation(this.spatial.getWorldRotation());
            int i = 0;
            for (VehicleWheel physicsVehicleWheel : this.wheels) {
                Vector3f location = physicsVehicleWheel.getLocation().clone();
                Vector3f direction = physicsVehicleWheel.getDirection().clone();
                Vector3f axle = physicsVehicleWheel.getAxle().clone();
                float restLength = physicsVehicleWheel.getRestLength();
                float radius = physicsVehicleWheel.getRadius();
                Geometry locGeom = (Geometry)debugNode.getChild("WheelLocationDebugShape" + i);
                Geometry dirGeom = (Geometry)debugNode.getChild("WheelDirectionDebugShape" + i);
                Geometry axleGeom = (Geometry)debugNode.getChild("WheelAxleDebugShape" + i);
                Geometry wheelGeom = (Geometry)debugNode.getChild("WheelRadiusDebugShape" + i);
                Arrow locArrow = (Arrow)locGeom.getMesh();
                locArrow.setArrowExtent(location);
                Arrow axleArrow = (Arrow)axleGeom.getMesh();
                axleArrow.setArrowExtent(axle.normalizeLocal().multLocal(0.3f));
                Arrow wheelArrow = (Arrow)wheelGeom.getMesh();
                wheelArrow.setArrowExtent(direction.normalizeLocal().multLocal(radius));
                Arrow dirArrow = (Arrow)dirGeom.getMesh();
                dirArrow.setArrowExtent(direction.normalizeLocal().multLocal(restLength));
                dirGeom.setLocalTranslation(location);
                axleGeom.setLocalTranslation(location.addLocal(direction));
                wheelGeom.setLocalTranslation(location);
                ++i;
            }
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            rm.renderScene(this.debugShape, vp);
        }
    }

    public void setPhysicsSpace(PhysicsSpace space) {
        this.createVehicle(space);
        if (space == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == space) {
                return;
            }
            space.addCollisionObject(this);
            this.added = true;
        }
        this.space = space;
    }

    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.motionState.isApplyPhysicsLocal(), "applyLocalPhysics", false);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.motionState.setApplyPhysicsLocal(ic.readBoolean("applyLocalPhysics", false));
        this.setUserObject(this.spatial);
    }
}

